
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_KIT_OFERTA_EST_PROD_DROGASMIL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_KIT_OFERTA_EST_PROD_DROGASMIL]
GO

CREATE PROCEDURE [dbo].[P_EST_PROD_KIT_OFERTA_EST_PROD_DROGASMIL] (@CD_FILIAL INT)
--@TIPO_COD_PROD
-- 0 - POR CÓDIGO DE PRODUTO
-- 1 - POR CÓDIGO DE FAMÍLIA

AS
BEGIN

DECLARE @CODIGO INT
DECLARE @CD_PROD INT
DECLARE @DATA DATETIME

SET NOCOUNT ON

SELECT @DATA = DBO.F_HOJE()

SET NOCOUNT ON

SELECT @DATA = DBO.F_HOJE()

CREATE TABLE #RS_PRODUTOS (
	CD_EMP INT,
	CD_PROD INT)

CREATE TABLE #RS_DESCONTO_PROG (
	CD_FILIAL INT,
	CD_PROD INT,
	PERC_DESC MONEY)

CREATE TABLE #RS_PRECO (
	CD_EMP INT,
	CD_FILIAL INT,
	CD_PROD INT,
	VLR_PRODUTO MONEY,
	VLR_TABELA MONEY,
	VLR_OFERTA MONEY)

DECLARE @RS_RETORNO TABLE (
	CODIGO			INT,
	CODIGO_GESTAO	INT,
	NM_PROMOCAO		VARCHAR(100),
	DT_INI			DATETIME,
	DT_FIM			DATETIME,
	TIPO_OFERTA		INT,
	TIPO_VALOR		INT,
	CD_FILIAL		INT,
	CD_PROD			INT,
	QT_PROD			MONEY,
	PERC_DESC_QTDE	MONEY,
	CD_PROD_OFERTADO INT,
	QTDE_LEVE		INT,
	CUMULATIVO		INT,
	VLR_PRODUTO		MONEY,
	TIPO_COD_PROD   INT,
	TIPO_COD_PROD_OFERTADO INT)

INSERT INTO
	#RS_PRODUTOS
SELECT
	1,
	CD_PROD
FROM
	V_EST_PROD_KIT_OFERTA_EST_PROD_DROGASMIL 
	
WHERE
	CD_FILIAL = @CD_FILIAL

INSERT INTO 
	#RS_DESCONTO_PROG
SELECT
	EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_FILIAL,
	TBPROD.CD_PROD,
	MAX(EST_PROD_PRECO_DESC_PRG_CPL.PERC_DESC)
FROM
	EST_PROD_PRECO_DESC_PRG		
	INNER JOIN EST_PROD_PRECO_DESC_PRG_CPL ON
		EST_PROD_PRECO_DESC_PRG.CD_PRECO_PRG = EST_PROD_PRECO_DESC_PRG_CPL.CD_PRECO_PRG
		AND EST_PROD_PRECO_DESC_PRG_CPL.CD_EMP = 1		
	INNER JOIN #RS_PRODUTOS TBPROD ON
		EST_PROD_PRECO_DESC_PRG_CPL.CD_EMP = TBPROD.CD_EMP
		AND EST_PROD_PRECO_DESC_PRG_CPL.CD_PROD = TBPROD.CD_PROD
	INNER JOIN EST_PROD_PRECO_DESC_PRG_PRC_FILIAL ON
		EST_PROD_PRECO_DESC_PRG.CD_PRECO_PRG = EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_PRECO_PRG
		AND EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_EMP = 1
WHERE 
	EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_FILIAL = @CD_FILIAL 
	AND @DATA BETWEEN EST_PROD_PRECO_DESC_PRG.DT_INI AND EST_PROD_PRECO_DESC_PRG.DT_VENCTO
GROUP BY
	EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_FILIAL,
	EST_PROD_PRECO_DESC_PRG_CPL.CD_PROD,
	TBPROD.CD_PROD

INSERT INTO
	#RS_PRECO
SELECT
	P.CD_EMP,
	P.CD_FILIAL,
	TBPROD.CD_PROD,
	P.VLR_TABELA,
	P.VLR_TABELA,
	P.VLR_OFERTA
FROM 
	EST_PROD_PRECO P
	INNER JOIN #RS_PRODUTOS TBPROD ON
		P.CD_EMP = TBPROD.CD_EMP
		AND P.CD_PROD = TBPROD.CD_PROD
		AND P.CD_FILIAL = @CD_FILIAL
WHERE
	P.CD_EMP = 1
	AND P.CD_FILIAL = @CD_FILIAL


UPDATE 
	P
SET 
	P.VLR_PRODUTO = 
	CASE WHEN P.VLR_OFERTA > 0 THEN
		P.VLR_OFERTA
	ELSE
		CASE WHEN D.PERC_DESC > 0 THEN
			P.VLR_TABELA - (P.VLR_TABELA * COALESCE(D.PERC_DESC,0) / 100)
		ELSE
			P.VLR_TABELA
		END
	END
FROM
	#RS_PRECO P
	LEFT JOIN #RS_DESCONTO_PROG D ON
		P.CD_FILIAL = D.CD_FILIAL
		AND P.CD_PROD = D.CD_PROD


INSERT INTO 
	@RS_RETORNO (CODIGO,
				CODIGO_GESTAO,
				NM_PROMOCAO,
				DT_INI,
				DT_FIM,
				TIPO_OFERTA,
				TIPO_VALOR,
				CD_FILIAL,
				CD_PROD,
				QT_PROD,
				PERC_DESC_QTDE,
				CD_PROD_OFERTADO,
				QTDE_LEVE,
				CUMULATIVO,
				VLR_PRODUTO,
				TIPO_COD_PROD,
				TIPO_COD_PROD_OFERTADO)	
SELECT 
	K.CODIGO,
	K.CODIGO_GESTAO,
	K.NM_PROMOCAO,
	K.DT_INI,
	K.DT_FIM,
	K.TIPO_OFERTA,
	K.TIPO_VALOR,
	K.CD_FILIAL,

	CASE WHEN K.FLAG_FAMILIA = 0 THEN
		K.CD_PROD
	ELSE
		K.CD_ARV_MERC_FAMILIA 
	END AS CD_PROD,

	K.QTDE_LEVE,
	K.PERC_DESC_QTDE,

	CASE WHEN K.FLAG_FAMILIA_OFERTA = 0 THEN
		K.CD_PROD_OFERTADO
	ELSE
		K.CD_ARV_MERC_FAMILIA_OFERTADO
	END AS CD_PROD_OFERTADO,
	
	K.QT_PROD,
	K.CUMULATIVO,
	--P.VLR_PROD - (P.VLR_PROD * K.PERC_DESC_QTDE / 100) AS VLR_PROD
	
	CASE WHEN K.PERC_DESC_QTDE > 0 THEN
		K.PERC_DESC_QTDE
	ELSE
		P.VLR_PRODUTO
	END AS VLR_PROD,

	CASE WHEN K.FLAG_FAMILIA = 0 THEN
		0
	ELSE
		1
	END AS TIPO_COD_PROD,

	CASE WHEN K.FLAG_FAMILIA_OFERTA = 0 THEN
		0
	ELSE
		1
	END AS TIPO_COD_PROD_OFERTADO
FROM
	V_EST_PROD_KIT_OFERTA_EST_PROD_DROGASMIL K
	INNER JOIN #RS_PRECO P ON
		K.CD_FILIAL = P.CD_FILIAL
		AND K.CD_PROD = P.CD_PROD

ORDER BY
	CASE WHEN K.FLAG_FAMILIA = 0 THEN
		0
	ELSE
		1
	END DESC,

	CASE WHEN K.FLAG_FAMILIA = 0 THEN
		K.CD_PROD
	ELSE
		K.CD_ARV_MERC_FAMILIA 
	END ASC,

	CASE WHEN K.FLAG_FAMILIA_OFERTA = 0 THEN
		K.CD_PROD_OFERTADO
	ELSE
		K.CD_ARV_MERC_FAMILIA_OFERTADO 
	END

SET NOCOUNT OFF

UPDATE R
SET CD_PROD = VPU.CD_PROD_BANDEIRA
FROM @RS_RETORNO R
INNER JOIN V_CAD_UNICO_DEPARAS_EST_PROD VPU ON
	R.CD_FILIAL = VPU.CD_FILIAL AND
	R.CD_PROD = VPU.CD_PROD


SELECT 
	*,
	(SELECT COUNT(*) FROM @RS_RETORNO) AS NR_REGISTROS
FROM 
	@RS_RETORNO


END
























GO


